package ru.yandex.direct.juggler;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.utils.SystemUtils;

public class JugglerEvent {
    static final String DEFAULT_INSTANCE = "";

    @JsonProperty
    private final String description;
    @JsonProperty
    private final String host;
    @JsonProperty
    private final String instance;
    @JsonProperty
    private final String service;
    @JsonProperty
    private final JugglerStatus status;

    public JugglerEvent(String host, String service, String instance, JugglerStatus status, String description) {
        this.description = description;
        this.host = host;
        this.instance = instance;
        this.service = service;
        this.status = status;
    }

    public JugglerEvent(String host, String service, JugglerStatus status, String description) {
        this(host, service, DEFAULT_INSTANCE, status, description);
    }

    public JugglerEvent(String service, JugglerStatus status, String description) {
        this(SystemUtils.strictHostname(), service, status, description);
    }

    public String getDescription() {
        return description;
    }

    public String getHost() {
        return host;
    }

    public String getInstance() {
        return instance;
    }

    public String getService() {
        return service;
    }

    public JugglerStatus getStatus() {
        return status;
    }

    public JugglerEvent withService(String service) {
        return new JugglerEvent(host, service, instance, status, description);
    }

    @Override
    public String toString() {
        return "JugglerEvent{" +
                "status=" + status +
                ", description='" + description + '\'' +
                ", host='" + host + '\'' +
                ", instance='" + instance + '\'' +
                ", service='" + service + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JugglerEvent that = (JugglerEvent) o;
        return Objects.equals(description, that.description) &&
                Objects.equals(host, that.host) &&
                Objects.equals(instance, that.instance) &&
                Objects.equals(service, that.service) &&
                status == that.status;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, host, instance, service, status);
    }
}
