package ru.yandex.direct.juggler;

import ru.yandex.direct.utils.MonotonicTime;

/**
 * Событие с дедлайном. Используется внутри JugglerAsyncSender для контроля таймаута отправки события.
 */
class JugglerEventWithDeadline {
    private final JugglerEvent event;
    private final MonotonicTime deadline;

    JugglerEventWithDeadline(JugglerEvent event, MonotonicTime deadline) {
        this.event = event;
        this.deadline = deadline;
    }

    JugglerEvent getEvent() {
        return event;
    }

    boolean isTimedOutAt(MonotonicTime time) {
        return time.isAfter(deadline);
    }
}
