package ru.yandex.direct.juggler;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import static java.net.HttpURLConnection.HTTP_OK;

public class JugglerResponse {
    private List<EventResponse> events;
    private long acceptedEvents;
    private boolean success;

    @JsonCreator
    public JugglerResponse(@JsonProperty("events") List<EventResponse> events,
                           @JsonProperty("accepted_events") Long acceptedEvents,
                           @JsonProperty("success") Boolean success) {
        this.events = events;
        this.acceptedEvents = acceptedEvents != null
                ? acceptedEvents
                : events.stream().filter(event -> event.code == HTTP_OK).count();
        this.success = success != null
                ? success
                : this.acceptedEvents == events.size();
    }

    List<FailedEvent> getFailedEvents(List<JugglerEvent> origEvents) {
        List<FailedEvent> failedEvents = new ArrayList<>();
        for (int i = 0; i < events.size(); i++) {
            if (events.get(i).code != HTTP_OK) {
                failedEvents.add(new FailedEvent(events.get(i), origEvents.get(i)));
            }
        }
        return failedEvents;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public static class EventResponse {
        private String message;
        private int code;

        @JsonCreator
        public EventResponse(@JsonProperty("message") String message, @JsonProperty("code") int code) {
            this.message = message;
            this.code = code;
        }

        @Override
        public String toString() {
            return ReflectionToStringBuilder.toString(this);
        }
    }

    public static class FailedEvent {
        private EventResponse eventResponse;
        private JugglerEvent event;

        public FailedEvent(EventResponse eventResponse, JugglerEvent event) {
            this.eventResponse = eventResponse;
            this.event = event;
        }

        public EventResponse getEventResponse() {
            return eventResponse;
        }

        public JugglerEvent getEvent() {
            return event;
        }

        @Override
        public String toString() {
            return ReflectionToStringBuilder.toString(this);
        }
    }
}
