parser grammar DirectKeywordParser;

options { tokenVocab=AdvqQueryLexer; }

phrase
    : unquotedWords
    | quotedWords
    ;

quotedWords
    : QUOTE SPACE? unquotedWords SPACE? QUOTE
    ;

unquotedWords
    : andArg (SPACE andArg)*
    ;

andArg
    : word
    | squareBrackets
    ;

squareBrackets
    : '[' SPACE? word (SPACE word)* SPACE? ']'
    ;

word
    : plusWord
    | fixedWord
    | rawWord
    ;

plusWord
    : PLUS WORD
    ;

fixedWord
    : FIXED WORD
    ;

rawWord
    : WORD
    ;

