package ru.yandex.direct.libs.keywordutils;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.advq.query.ast.Word;
import ru.yandex.advq.query.ast.WordKind;
import ru.yandex.direct.libs.keywordutils.model.AnyKeyword;
import ru.yandex.direct.libs.keywordutils.model.Keyword;
import ru.yandex.direct.libs.keywordutils.model.OrderedKeyword;
import ru.yandex.direct.libs.keywordutils.model.SingleKeyword;

import static java.util.stream.Collectors.toList;

public class KeywordUtils {

    /**
     * Вырезать из Keyword все незафиксированные стоп-слова
     */
    public static Keyword stripStopWords(Keyword keyword, StopWordMatcher stopWordMatcher) {
        List<AnyKeyword> filteredKeywords = new ArrayList<>();
        for (AnyKeyword anyKeyword : keyword.getAllKeywords()) {
            if (anyKeyword instanceof SingleKeyword) {
                if (!isStripeable(((SingleKeyword) anyKeyword), stopWordMatcher)) {
                    filteredKeywords.add(anyKeyword);
                }
            } else if (anyKeyword instanceof OrderedKeyword) {
                List<SingleKeyword> words = ((OrderedKeyword) anyKeyword).getSingleKeywords().stream()
                        .filter(w -> !isStripeable(w, stopWordMatcher))
                        .collect(toList());
                if (!words.isEmpty()) {
                    filteredKeywords.add(new OrderedKeyword(words));
                }
            } else {
                throw new IllegalStateException(
                        "Unsupported keyword type: " + anyKeyword.getClass().getCanonicalName());
            }
        }
        return new Keyword(keyword.isQuoted(), filteredKeywords);
    }

    private static boolean isStripeable(SingleKeyword anyKeyword, StopWordMatcher stopWordMatcher) {
        Word word = anyKeyword.getWord();
        return word.getKind() != WordKind.PLUS
                && word.getKind() != WordKind.FIXED
                && stopWordMatcher.isStopWord(word.getText());
    }

}
