package ru.yandex.direct.libs.keywordutils.helper;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.clemmer.Clemmer;
import ru.yandex.direct.clemmer.ClemmerLanguage;
import ru.yandex.direct.clemmer.ClemmerWord;
import ru.yandex.direct.libs.cachingutils.DirectLoadingCache;

/**
 * Кэширование ответов clemmer'а.
 * <p>
 * При обработке фраз одной кампании в фразах встречается много дубликатов. Кэширование позволяет значительно ускорить
 * лемматизацию фраз.
 */
@SuppressWarnings("WeakerAccess")
@ParametersAreNonnullByDefault
public class ClemmerCache extends DirectLoadingCache<String, List<ClemmerWord>> {
    public ClemmerCache() {
        super();
    }

    public ClemmerCache(int size) {
        super(size);
    }

    @Override
    protected List<ClemmerWord> getValue(String key) {
        return Clemmer.analyze2(key, ClemmerLanguage.RUSSIAN, false);
    }

    @Override
    @Nonnull
    protected String solomonSensorName() {
        return "clemmer_cache";
    }
}
