package ru.yandex.direct.libs.keywordutils.helper;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.libs.cachingutils.DirectLoadingCache;
import ru.yandex.direct.libs.keywordutils.model.Keyword;
import ru.yandex.direct.libs.keywordutils.parser.KeywordParser;

/**
 * Кэширование парсинга ключевых фраз.
 * <p>
 * При обработке фраз одной кампании в фразах встречается много дубликатов. Кэширование позволяет значительно ускорить
 * парсинг фраз.
 */
@SuppressWarnings("WeakerAccess")
@ParametersAreNonnullByDefault
public class ParseKeywordCache extends DirectLoadingCache<String, Keyword> {
    public ParseKeywordCache() {
        super();
    }

    public ParseKeywordCache(int size) {
        super(size);
    }

    @Override
    protected Keyword getValue(String key) {
        return KeywordParser.parse(key);
    }

    public Keyword parse(String key) {
        return getCached(key);
    }

    @Override
    @Nonnull
    protected String solomonSensorName() {
        return "keyword_cache";
    }
}
