package ru.yandex.direct.libs.keywordutils.helper;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.advq.query.ast.Word;
import ru.yandex.direct.libs.cachingutils.DirectLoadingCache;
import ru.yandex.direct.libs.keywordutils.inclusion.model.SingleKeywordFactory;
import ru.yandex.direct.libs.keywordutils.inclusion.model.SingleKeywordWithLemmas;

@ParametersAreNonnullByDefault
public class SingleKeywordsCache extends DirectLoadingCache<Word, List<SingleKeywordWithLemmas>> {
    private final SingleKeywordFactory singleKeywordFactory;

    public SingleKeywordsCache() {
        this(new ClemmerCache());
    }

    public SingleKeywordsCache(int clemmerCacheCapacity, int singleKeywordsCacheCapacity) {
        this(new ClemmerCache(clemmerCacheCapacity), singleKeywordsCacheCapacity);
    }

    public SingleKeywordsCache(ClemmerCache clemmerCache) {
        super();
        this.singleKeywordFactory = new SingleKeywordFactory(clemmerCache);
    }

    public SingleKeywordsCache(ClemmerCache clemmerCache, int size) {
        super(size);
        this.singleKeywordFactory = new SingleKeywordFactory(clemmerCache);
    }

    @Override
    protected List<SingleKeywordWithLemmas> getValue(Word key) {
        return singleKeywordFactory.singleKeywordsFrom(key);
    }

    public List<SingleKeywordWithLemmas> singleKeywordsFrom(Word key) {
        return getCached(key);
    }

    @Nonnull
    @Override
    protected String solomonSensorName() {
        return "single_keywords_cache";
    }
}
