package ru.yandex.direct.libs.keywordutils.inclusion.model;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.advq.query.ast.Word;
import ru.yandex.advq.query.ast.WordKind;
import ru.yandex.direct.libs.keywordutils.model.AnyKeyword;

@ParametersAreNonnullByDefault
public class SingleKeywordWithLemmas implements AnyKeyword {
    private final Word word;
    private final List<String> lemmas;

    SingleKeywordWithLemmas(Word word, List<String> lemmas) {
        this.word = word;
        this.lemmas = lemmas;
    }

    @Override
    public String toString() {
        return word.toString();
    }

    public boolean isFixed() {
        return word.getKind() == WordKind.FIXED;
    }

    public boolean isPlus() {
        return word.getKind() == WordKind.PLUS;
    }

    public boolean isRaw() {
        return word.getKind() == WordKind.RAW;
    }

    public String getNormalizedForm() {
        return word.getText();
    }

    public List<String> getLemmas() {
        return lemmas;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SingleKeywordWithLemmas that = (SingleKeywordWithLemmas) o;
        return word.getKind() == that.word.getKind() &&
                Objects.equals(word.getText(), that.word.getText());
    }

    @Override
    public int hashCode() {
        return Objects.hash(word.getText(), word.getKind());
    }
}
