package ru.yandex.direct.libs.keywordutils.model;

import java.util.List;
import java.util.Objects;

import one.util.streamex.StreamEx;

import ru.yandex.advq.query.ast.Expression;
import ru.yandex.direct.libs.keywordutils.parser.KeywordBuilder;

public class Keyword {
    private final List<AnyKeyword> allKeywords;
    private final boolean quoted;

    public Keyword(List<AnyKeyword> allKeywords) {
        this(false, allKeywords);
    }

    public Keyword(boolean quoted, List<AnyKeyword> allKeywords) {
        this.allKeywords = allKeywords;
        this.quoted = quoted;
    }

    public static Keyword from(Expression expression) {
        return KeywordBuilder.from(expression).build();
    }

    public List<AnyKeyword> getAllKeywords() {
        return allKeywords;
    }

    public boolean isQuoted() {
        return quoted;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (quoted) {
            sb.append('"');
        }
        sb.append(StreamEx.of(allKeywords)
                .map(Object::toString)
                .joining(" "));
        if (quoted) {
            sb.append('"');
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Keyword keyword = (Keyword) o;
        return quoted == keyword.quoted &&
                Objects.equals(allKeywords, keyword.allKeywords);
    }

    @Override
    public int hashCode() {
        return Objects.hash(allKeywords, quoted);
    }
}
