package ru.yandex.direct.libs.keywordutils.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static java.util.Collections.emptyList;

public class KeywordWithMinuses {

    private Keyword keyword;
    private List<Keyword> minusKeywords;

    public KeywordWithMinuses(Keyword keyword) {
        this(keyword, emptyList());
    }

    public KeywordWithMinuses(Keyword keyword, List<Keyword> minusKeywords) {
        this.keyword = keyword;
        this.minusKeywords = minusKeywords;
    }

    public Keyword getKeyword() {
        return keyword;
    }

    public List<Keyword> getMinusKeywords() {
        return minusKeywords;
    }

    public KeywordWithMinuses appendMinuses(List<Keyword> minusKeywords) {
        List<Keyword> newMinusKeywords = new ArrayList<>(this.minusKeywords);
        newMinusKeywords.addAll(minusKeywords);
        return new KeywordWithMinuses(this.keyword, newMinusKeywords);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(keyword);

        for (Keyword minusKeyword : minusKeywords) {
            sb.append(" -").append(minusKeyword);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        KeywordWithMinuses that = (KeywordWithMinuses) o;
        return Objects.equals(keyword, that.keyword) &&
                Objects.equals(minusKeywords, that.minusKeywords);
    }

    @Override
    public int hashCode() {

        return Objects.hash(keyword, minusKeywords);
    }
}
