package ru.yandex.direct.libs.keywordutils.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

@ParametersAreNonnullByDefault
public class OrderedKeyword implements AnyKeyword {

    private final List<SingleKeyword> singleKeywords;

    public OrderedKeyword(List<SingleKeyword> singleKeywords) {
        this.singleKeywords = Collections.unmodifiableList(singleKeywords);
    }

    public List<SingleKeyword> getSingleKeywords() {
        return singleKeywords;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrderedKeyword that = (OrderedKeyword) o;
        return Objects.equals(singleKeywords, that.singleKeywords);
    }

    @Override
    public int hashCode() {
        return Objects.hash(singleKeywords);
    }

    @Override
    public String toString() {
        return String
                .format("[%s]", StreamEx.of(singleKeywords).map(SingleKeyword::toString).joining(" "));
    }
}
