package ru.yandex.direct.libs.keywordutils.model;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.advq.query.ast.Word;
import ru.yandex.advq.query.ast.WordKind;

@ParametersAreNonnullByDefault
public class SingleKeyword implements AnyKeyword {
    private final Word word;

    public SingleKeyword(Word word) {
        this.word = word;
    }

    public static SingleKeyword from(String word) {
        WordKind kind;
        switch (word.charAt(0)) {
            case '+':
                kind = WordKind.PLUS;
                break;
            case '!':
                kind = WordKind.FIXED;
                break;
            default:
                kind = WordKind.RAW;
        }
        String normalized;
        if (kind == WordKind.RAW) {
            // нет оператора
            normalized = word;
        } else {
            normalized = word.substring(1);
        }
        Word advqWord = new Word(kind, normalized);
        return new SingleKeyword(advqWord);
    }

    @Override
    public int hashCode() {
        return Objects.hash(word.getKind(), word.getText());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleKeyword that = (SingleKeyword) o;
        return Objects.equals(this.word.getKind(), that.word.getKind())
                && Objects.equals(this.word.getText(), that.word.getText());
    }

    public Word getWord() {
        return word;
    }

    @Override
    public String toString() {
        return word.toString();
    }
}
