package ru.yandex.direct.libs.keywordutils.parser;

import java.util.ArrayList;
import java.util.List;

import one.util.streamex.StreamEx;

import ru.yandex.advq.query.ast.Expression;
import ru.yandex.advq.query.ast.Word;
import ru.yandex.direct.libs.keywordutils.model.AnyKeyword;
import ru.yandex.direct.libs.keywordutils.model.Keyword;
import ru.yandex.direct.libs.keywordutils.model.OrderedKeyword;
import ru.yandex.direct.libs.keywordutils.model.SingleKeyword;

import static com.google.common.base.Preconditions.checkState;

public class KeywordBuilder {
    private final List<AnyKeyword> allKeywords;
    private List<SingleKeyword> currentOrderedKeyword;
    private boolean quoted;

    KeywordBuilder() {
        allKeywords = new ArrayList<>();
        quoted = false;
        currentOrderedKeyword = null;
    }

    public static KeywordBuilder from(Expression expression) {
        return expression.accept(new KeywordBuilderVisitor());
    }

    public Keyword build() {
        return new Keyword(quoted, allKeywords);
    }

    KeywordBuilder exact() {
        this.quoted = true;
        return this;
    }

    KeywordBuilder startBrackets() {
        checkState(this.currentOrderedKeyword == null,
                "current keywordBuilder is in 'filling square brackets' state");
        currentOrderedKeyword = new ArrayList<>();
        return this;
    }

    KeywordBuilder pushWord(Word word) {
        SingleKeyword singleKeyword = new SingleKeyword(word);
        if (currentOrderedKeyword == null) {
            allKeywords.add(singleKeyword);
        } else {
            currentOrderedKeyword.add(singleKeyword);
        }
        return this;
    }

    KeywordBuilder endBrackets() {
        checkState(this.currentOrderedKeyword != null,
                "current keywordBuilder is not in 'filling square brackets' state");
        allKeywords.add(new OrderedKeyword(currentOrderedKeyword));
        currentOrderedKeyword = null;
        return this;
    }

    /**
     * @param other other {@link KeywordBuilder}
     * @return {@code other} with added elements from current {@link KeywordBuilder}
     */
    KeywordBuilder addTo(KeywordBuilder other) {
        checkState(this.currentOrderedKeyword == null,
                "current keywordBuilder is in 'filling square brackets' state");
        checkState(!this.quoted, "can't add keywordBuilder with quoted flag to other keywordBuilder");
//            checkState(other.currentOrderedKeyword == null || this.orderedKeywords.isEmpty(), "can't add keywordBuilder with orderedKeywords in opened other.orderedKeyword");

        if (other.currentOrderedKeyword != null) {
            StreamEx.of(this.allKeywords)
                    .filter(SingleKeyword.class::isInstance)
                    .map(SingleKeyword.class::cast)
                    .forEach(other.currentOrderedKeyword::add);
        } else {
            other.allKeywords.addAll(this.allKeywords);
        }
        return other;
    }

}
