package ru.yandex.direct.libs.keywordutils.parser;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.advq.query.ast.Difference;
import ru.yandex.advq.query.ast.Expression;
import ru.yandex.advq.query.ast.Union;
import ru.yandex.direct.libs.keywordutils.model.Keyword;
import ru.yandex.direct.libs.keywordutils.model.KeywordWithMinuses;

import static com.google.common.base.Preconditions.checkArgument;

public class KeywordWithMinusesBuilder {

    private KeywordWithMinusesBuilder() {
    }

    public static KeywordWithMinuses buildKeywordWithMinusesFrom(Expression expression) {
        // Проверим корневой Expression
        if (expression instanceof Difference) {
            /*
              Если это Difference, то у нас такая структура:
              > Difference
                > left:
                  Expression (с ключевой фразой)
                > right:
                  Union
                  > children:
                    Expression (с минус-фразой)
                    ...
             */
            Difference difference = (Difference) expression;

            Keyword keyword = KeywordBuilder.from(difference.getLeft()).build();
            List<Keyword> minusKeywords = buildKeywordsFromRightExpression(difference.getRight());
            return new KeywordWithMinuses(keyword, minusKeywords);
        } else {
            // Если это не Difference, то в Expression просто ключевая фраза без минус-фраз
            Keyword keyword = KeywordBuilder.from(expression).build();
            return new KeywordWithMinuses(keyword);
        }
    }

    /**
     * Из объединения Expression'ов создаёт список Keyword'ов.
     */
    private static List<Keyword> buildKeywordsFromRightExpression(Expression rightExpression) {
        checkArgument(rightExpression instanceof Union, "Expected Union. Got: " + rightExpression);
        Union union = (Union) rightExpression;

        return union.getChildren()
                .stream()
                .map(e -> KeywordBuilder.from(e).build())
                .collect(Collectors.toList());
    }

}
