package ru.yandex.direct.libs.keywordutils.parser;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.advq.query.ast.Expression;
import ru.yandex.advq.query.ast.ExpressionTransform;
import ru.yandex.advq.query.ast.Word;

public class ReplaceCharsExpressionTransform extends ExpressionTransform {

    public static final ReplaceCharsExpressionTransform INSTANCE = new ReplaceCharsExpressionTransform();

    @Override
    public Expression visitWord(Word word) {
        String oldText = word.getText();
        String newText = StringUtils.replace(oldText, "ё", "е");
        newText = StringUtils.replace(newText, "Ё", "Е");
        return new Word(word.getKind(), newText);
    }
}
