JAVA_LIBRARY()

INCLUDE(${ARCADIA_ROOT}/direct/libs/common.inc)

OWNER(g:direct)

PEERDIR(
    advq/java/libs/query-parser
    direct/libs/caching-utils
    direct/libs/clemmer
    direct/libs/metric-collector
    direct/libs/solomon
    direct/libs/tracing

    library/java/monlib/metrics

    contrib/java/com/google/code/findbugs/jsr305
    contrib/java/com/google/guava/guava
    contrib/java/one/util/streamex
    contrib/java/org/antlr/antlr4-runtime
    # Logging
    contrib/java/org/slf4j/slf4j-api
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR ${BINDIR}/generated **/*)

SET(antlr4_inputs
    ${ARCADIA_ROOT}/advq/java/libs/query-parser/src/main/antlr4/ru/yandex/advq/query/parser/AdvqQueryLexer.g4
    src/main/antlr4/ru/yandex/direct/libs/keywordutils/parser/DirectKeywordParser.g4
)

RUN_JAVA_PROGRAM(
    ru.yandex.advq.tools.AntlrGenerator
    ${antlr4_inputs}
    -o ${BINDIR}/generated -visitor
    -package ru.yandex.direct.libs.keywordutils.parser
    IN ${antlr4_inputs}
    OUT_DIR generated
    CLASSPATH advq/java/tools/antlr-generator
)

END()

RECURSE_FOR_TESTS(ut)
