package ru.yandex.direct.libs.laas;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Cookie;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Header;
import ru.yandex.direct.http.smart.http.Query;

public interface LaasApi {

    /**
     * Получение региона пользователя.
     *
     * @param service       Сервис, отправляющий запрос (direct)
     * @param userIp        IP-адрес пользователя
     * @param yandexUid     Уникальный идентификатор пользователя
     * @param yandexGid     Регион пользователя из куки yandex_gid
     * @param yp            Контейнер для куки gpauto и ygu (yp=<кука gpauto>#<кука ygu>)
     */
    @GET("/region")
    @Json
    Call<RegionResponse> getRegion(
            @Query("service") String service,
            @Header("X-Real-IP") String userIp,
            @Cookie("yandexuid") String yandexUid,
            @Cookie("yandex_gid") Long yandexGid,
            @Cookie("yp") String yp);
}
