package ru.yandex.direct.libs.laas;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.http.smart.core.Smart;

/**
 * Клиент к LaaS (Location as a Service) — внутренний сервис, который определяет местоположение пользователя.
 * https://doc.yandex-team.ru/laas/laas-user/concepts/about.html
 */
public class LaasClient {
    private static final Logger logger = LoggerFactory.getLogger(LaasClient.class);

    private final LaasApi laasApi;

    public LaasClient(String baseUrl, ParallelFetcherFactory fetcherFactory) {

        this.laasApi = Smart.builder()
                .withParallelFetcherFactory(fetcherFactory)
                .withProfileName("laas_client")
                .withBaseUrl(baseUrl)
                .build()
                .create(LaasApi.class);
    }

    LaasClient(LaasApi laasApi) {
        this.laasApi = laasApi;
    }

    public Optional<Long> getRegionId(String userIp, String yandexUid, Long yandexGid, String ypCookie) {
        Result<RegionResponse> result =
                laasApi.getRegion("direct", userIp, yandexUid, yandexGid, ypCookie).execute();
        if (result.getErrors() != null && !result.getErrors().isEmpty()) {
            logger.error("Got errors while getting region from LaaS: {}", result.getErrors());
            return Optional.empty();
        }
        return Optional.of(result.getSuccess().getRegionId());
    }
}
