package ru.yandex.direct.landlord.client;

import maps_adv.geosmb.landlord.proto.generate.Generate;
import maps_adv.geosmb.landlord.proto.internal.landing_details.LandingDetailsOuterClass;

import ru.yandex.direct.http.smart.annotations.Proto;
import ru.yandex.direct.http.smart.annotations.ResponseHandler;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.Headers;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.landlord.client.converter.EditLandingOutputConverter;
import ru.yandex.direct.landlord.client.converter.GenerateLandingOutputConverter;
import ru.yandex.direct.landlord.client.converter.ShowLandingOutputConverter;

public interface LandlordApi {

    @POST("/v1/show_landing_details/")
    @Headers("Content-Type: application/protobuf")
    @ResponseHandler(parserClass = ShowLandingOutputConverter.class, expectedCodes = {200, 400})
    Call<LandingDetailsOuterClass.ShowLandingDetailsOutput> showLandingDetails(
            @Proto @Body LandingDetailsOuterClass.ShowLandingDetailsInput input
    );

    @POST("/v1/edit_landing_details/")
    @Headers("Content-Type: application/protobuf")
    @ResponseHandler(parserClass = EditLandingOutputConverter.class, expectedCodes = {200, 400})
    Call<LandingDetailsOuterClass.EditLandingDetailsOutput> editLandingDetails(
            @Proto @Body LandingDetailsOuterClass.EditLandingDetailsInput input
    );

    @POST("/v1/generate_landing_data/")
    @Headers("Content-Type: application/protobuf")
    @ResponseHandler(parserClass = GenerateLandingOutputConverter.class, expectedCodes = {201, 400})
    Call<Generate.GenerateDataOutput> generateLandingData(
            @Proto @Body Generate.GenerateDataInput input
    );

}
