package ru.yandex.direct.landlord.client.converter

import java.lang.reflect.Type
import com.google.protobuf.InvalidProtocolBufferException
import maps_adv.geosmb.landlord.proto.internal.landing_details.LandingDetailsOuterClass.EditLandingDetailsOutput
import org.asynchttpclient.Response
import org.slf4j.LoggerFactory
import ru.yandex.direct.http.smart.converter.ResponseConverter
import ru.yandex.direct.landlord.client.LandlordApiException

class EditLandingOutputConverter : ResponseConverter<EditLandingDetailsOutput?> {

    override fun convert(response: Response, responseType: Type): EditLandingDetailsOutput? {
        return try {
            val errorOrNull = getErrorOrNull(response)
            if (errorOrNull == null) {
                EditLandingDetailsOutput.parseFrom(response.responseBodyAsByteBuffer)
            } else {
                logger.error("Cannot edit landing details: $errorOrNull")
                null
            }
        } catch (e: InvalidProtocolBufferException) {
            throw LandlordApiException("Cannot deserialize response", e)
        }
    }

    companion object {
        private val logger = LoggerFactory.getLogger(EditLandingOutputConverter::class.java)
    }
}
