package ru.yandex.direct.landlord.client.converter

import com.google.protobuf.InvalidProtocolBufferException
import maps_adv.geosmb.landlord.proto.common.Common
import org.asynchttpclient.Response
import ru.yandex.direct.landlord.client.LandlordApiException

fun getErrorOrNull(response: Response): Common.Error? {
    return try {
        if (response.statusCode == 400) {
            Common.Error.parseFrom(response.responseBodyAsByteBuffer)
        } else {
            null
        }
    } catch (e: InvalidProtocolBufferException) {
        throw LandlordApiException("Cannot deserialize response", e)
    }
}
