package ru.yandex.direct.landlord.client.converter

import java.lang.reflect.Type
import com.google.protobuf.InvalidProtocolBufferException
import maps_adv.geosmb.landlord.proto.generate.Generate
import org.asynchttpclient.Response
import org.slf4j.LoggerFactory
import ru.yandex.direct.http.smart.converter.ResponseConverter
import ru.yandex.direct.landlord.client.LandlordApiException


class GenerateLandingOutputConverter : ResponseConverter<Generate.GenerateDataOutput?> {

    override fun convert(response: Response, responseType: Type): Generate.GenerateDataOutput? {
        return try {
            val errorOrNull = getErrorOrNull(response)
            if (errorOrNull == null) {
                Generate.GenerateDataOutput.parseFrom(response.responseBodyAsByteBuffer)
            } else {
                logger.error("Cannot generate landing data: $errorOrNull")
                null
            }
        } catch (e: InvalidProtocolBufferException) {
            throw LandlordApiException("Cannot deserialize response", e)
        }
    }

    companion object {
        private val logger = LoggerFactory.getLogger(GenerateLandingOutputConverter::class.java)
    }
}
