package ru.yandex.direct.mail;

import java.util.List;

import javax.annotation.Nullable;
import javax.mail.internet.MimeBodyPart;

public class AuthorizedMailMessage extends MailMessage {
    private Long operatorUid;
    private Long subjectUserClientId;

    public AuthorizedMailMessage(Long operatorUid, Long subjectUserClientId,
                                 EmailAddress from, EmailAddress to, String subject,
                                 String messageBody, EmailContentType contentType, @Nullable List<MimeBodyPart> attachments) {
        super(from, to, subject, messageBody, contentType, attachments);
        this.operatorUid = operatorUid;
        this.subjectUserClientId = subjectUserClientId;
    }

    public AuthorizedMailMessage(Long operatorUid, Long subjectUserClientId,
                                 EmailAddress from, EmailAddress to, String subject, String messageBody) {
        this(operatorUid, subjectUserClientId, from, to, subject, messageBody, EmailContentType.TEXT, null);
    }

    public Long getOperatorUid() {
        return operatorUid;
    }

    public void setOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
    }

    public AuthorizedMailMessage withOperatorUid(Long operatorUid) {
        setOperatorUid(operatorUid);
        return this;
    }

    public Long getSubjectUserClientId() {
        return subjectUserClientId;
    }

    public void setSubjectUserClientId(Long subjectUserClientId) {
        this.subjectUserClientId = subjectUserClientId;
    }

    public AuthorizedMailMessage withSubjectUserClientId(Long subjectUserClientId) {
        setSubjectUserClientId(subjectUserClientId);
        return this;
    }
}
