package ru.yandex.direct.mail;

import java.io.UnsupportedEncodingException;

import javax.mail.internet.InternetAddress;

public class EmailAddress {
    private final InternetAddress address;

    public EmailAddress(String email, String personal) {
        try {
            this.address = new InternetAddress(MailUtil.punifyEmailAddress(email), personal, MailUtil.DEFAULT_ENCODING);
        } catch (UnsupportedEncodingException ex) {
            throw new EmailException(ex);
        }
    }

    public String getEmail() {
        return address.getAddress();
    }

    public String getPersonal() {
        return address.getPersonal();
    }

    InternetAddress toInternetAddress() {
        return address;
    }

    @Override
    public String toString() {
        return address.toString();
    }
}
