package ru.yandex.direct.mail;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMailSender implements MailSender {
    private static final Logger logger = LoggerFactory.getLogger(LoggingMailSender.class);

    public LoggingMailSender() {
    }

    @Override
    public void send(MailMessage message) {
        logger.info("new mail just sent: from: {}, to: {}, subject: {},"
                        + "cc: {}, bcc: {}, replyTo: {}, "
                        + "contentType: {}, body: {}",
                message.getFrom(), message.getTo(), message.getSubject(),
                message.getCc(), message.getBcc(), message.getReplyTo(),
                message.getContentType(), message.getMessageBody());
    }
}
