package ru.yandex.direct.mail;

import java.net.IDN;
import java.util.List;

import com.google.common.base.Splitter;

class MailUtil {
    private static final Splitter EMAIL_SPLITTER = Splitter.on("@").limit(2);
    static final String RFC822_DATE_HEADER = "Date";
    static final String DEFAULT_ENCODING = "utf-8";

    private MailUtil() {
    }

    static String punifyEmailAddress(String address) {
        List<String> emailTokens = EMAIL_SPLITTER.splitToList(address);
        String username = emailTokens.get(0);
        String domain = emailTokens.get(1);
        return username + "@" + IDN.toASCII(domain);
    }

    static <T> boolean isNullOrEmpty(T[] src) {
        return src == null || src.length == 0;
    }
}
