package ru.yandex.direct.mail;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class RedirectingMailSender implements MailSender {
    private MailSender delegate;
    private String email;

    public RedirectingMailSender(MailSender delegate, String email) {
        this.delegate = delegate;
        this.email = email;
    }

    @Override
    public void send(MailMessage message) {
        clearCCAndBcc(message);
        delegate.send(message);
    }

    @Override
    public void send(AuthorizedMailMessage message) {
        clearCCAndBcc(message);
        delegate.send(message);
    }

    private void clearCCAndBcc(MailMessage message) {
        message.withTo(new EmailAddress(email, message.getTo().getPersonal()));
        message.withCc(null);
        message.withBcc(null);
    }
}
