package ru.yandex.direct.mediascope;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MediascopeClientConfig {
    private final String oidcUrl;
    private final String apiUrl;
    private final String clientId;
    private final String clientSecret;

    public MediascopeClientConfig(
            String oidcUrl,
            String apiUrl,
            String clientId,
            String clientSecret
    ) {
        this.oidcUrl = oidcUrl;
        this.apiUrl = apiUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public String getOidcUrl() {
        return oidcUrl;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public String getClientId() {
        return clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }
}

