package ru.yandex.direct.mediascope.model.request;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "position_id",
        "position_name",
        "creative_id",
        "creative_url",
        "start_dt",
        "finish_dt",
        "params"
})
public class MediascopePosition {

    @JsonProperty("position_id")
    private String positionId;

    @JsonProperty("position_name")
    private String positionName;

    @JsonProperty("creative_id")
    private String creativeId;

    @JsonProperty("creative_url")
    private String creativeUrl;

    @JsonProperty("start_dt")
    private String startDate;

    @JsonProperty("finish_dt")
    private String finishDate;

    @JsonProperty("params")
    private List<MediascopePositionParam> params = null;

    @JsonIgnore
    private String accessToken;

    @JsonProperty("position_id")
    public String getPositionId() {
        return positionId;
    }

    @JsonProperty("position_id")
    public MediascopePosition setPositionId(String positionId) {
        this.positionId = positionId;
        return this;
    }

    @JsonProperty("position_name")
    public String getPositionName() {
        return positionName;
    }

    @JsonProperty("position_name")
    public MediascopePosition setPositionName(String positionName) {
        this.positionName = positionName;
        return this;
    }

    @JsonProperty("creative_id")
    public String getCreativeId() {
        return creativeId;
    }

    @JsonProperty("creative_id")
    public MediascopePosition setCreativeId(String creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    @JsonProperty("creative_url")
    public String getCreativeUrl() {
        return creativeUrl;
    }

    @JsonProperty("creative_url")
    public MediascopePosition setCreativeUrl(String creativeUrl) {
        this.creativeUrl = creativeUrl;
        return this;
    }

    @JsonProperty("start_dt")
    public String getStartDate() {
        return startDate;
    }

    @JsonProperty("start_dt")
    public MediascopePosition setStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("finish_dt")
    public String getFinishDate() {
        return finishDate;
    }

    @JsonProperty("finish_dt")
    public MediascopePosition setFinishDate(String finishDate) {
        this.finishDate = finishDate;
        return this;
    }

    @JsonProperty("params")
    public List<MediascopePositionParam> getParams() {
        return params;
    }

    @JsonProperty("params")
    public MediascopePosition setParams(List<MediascopePositionParam> params) {
        this.params = params;
        return this;
    }

    @JsonIgnore
    public String getAccessToken() {
        return accessToken;
    }

    @JsonIgnore
    public MediascopePosition setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }
}
