package ru.yandex.direct.mediascope.model.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "param_name",
        "param_value"
})
public class MediascopePositionParam {

    @JsonProperty("param_name")
    private String paramName;

    @JsonProperty("param_value")
    private String paramValue;

    @JsonProperty("param_name")
    public String getParamName() {
        return paramName;
    }

    @JsonProperty("param_name")
    public MediascopePositionParam setParamName(String paramName) {
        this.paramName = paramName;
        return this;
    }

    @JsonProperty("param_value")
    public String getParamValue() {
        return paramValue;
    }

    @JsonProperty("param_value")
    public MediascopePositionParam setParamValue(String paramValue) {
        this.paramValue = paramValue;
        return this;
    }
}
