package ru.yandex.direct.mediascope.model.response;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "status",
        "message",
        "description",
        "errors"
})
public class MediascopePositionsResponse {

    @JsonProperty("status")
    private Long status;

    @JsonProperty("message")
    private String message;

    @JsonProperty("description")
    private String description;

    @JsonProperty("errors")
    private Map<String, String> errors;

    @JsonCreator
    public MediascopePositionsResponse(
            @JsonProperty("status") Long status,
            @JsonProperty("message") String message,
            @JsonProperty("description") String description,
            @JsonProperty("errors") Map<String, String> errors) {
        this.status = status;
        this.message = message;
        this.description = description;
        this.errors = errors;
    }

    @JsonProperty("status")
    public Long getStatus() {
        return status;
    }

    @JsonProperty("status")
    public void setStatus(Long status) {
        this.status = status;
    }

    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty("errors")
    public Map<String, String> getErrors() {
        return errors;
    }

    @JsonProperty("errors")
    public void setErrors(Map<String, String> errors) {
        this.errors = errors;
    }
}
