package ru.yandex.direct.metrika.client;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * A single API error as returned by metrika
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MetrikaApiError {
    private String errorType;
    private String message;
    private String location;


    @JsonCreator
    public MetrikaApiError(@JsonProperty("error_type") String errorType, @JsonProperty("message") String message,
                           @JsonProperty("location") String location) {
        this.errorType = errorType;
        this.message = message;
        this.location = location;
    }

    public String getErrorType() {
        return errorType;
    }

    public String getMessage() {
        return message;
    }

    public String getLocation() {
        return location;
    }

    @Override
    public String toString() {
        return "MetrikaApiError{" +
                "errorType=" + errorType +
                ", message='" + message + '\'' +
                ", location='" + location + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MetrikaApiError that = (MetrikaApiError) o;
        return Objects.equals(errorType, that.errorType) &&
                Objects.equals(message, that.message) &&
                Objects.equals(location, that.location);
    }

    @Override
    public int hashCode() {

        return Objects.hash(errorType, message, location);
    }
}
