package ru.yandex.direct.metrika.client;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;

import ru.yandex.direct.metrika.client.internal.MetrikaByTimeStatisticsParams;
import ru.yandex.direct.metrika.client.internal.MetrikaSourcesParams;
import ru.yandex.direct.metrika.client.model.request.GetExistentCountersRequest;
import ru.yandex.direct.metrika.client.model.request.GetGoalsRequest;
import ru.yandex.direct.metrika.client.model.request.GoalType;
import ru.yandex.direct.metrika.client.model.request.GrantAccessRequestStatusesRequest;
import ru.yandex.direct.metrika.client.model.request.RequestGrantsRequest;
import ru.yandex.direct.metrika.client.model.request.RetargetingGoalGroup;
import ru.yandex.direct.metrika.client.model.request.UserCountersExtendedFilter;
import ru.yandex.direct.metrika.client.model.response.Counter;
import ru.yandex.direct.metrika.client.model.response.CounterGoal;
import ru.yandex.direct.metrika.client.model.response.CreateCounterGoal;
import ru.yandex.direct.metrika.client.model.response.GetExistentCountersResponse;
import ru.yandex.direct.metrika.client.model.response.GetGoalsResponse;
import ru.yandex.direct.metrika.client.model.response.GoalConversionInfo;
import ru.yandex.direct.metrika.client.model.response.GrantAccessRequestStatusesResponse;
import ru.yandex.direct.metrika.client.model.response.RequestGrantsResponse;
import ru.yandex.direct.metrika.client.model.response.RetargetingCondition;
import ru.yandex.direct.metrika.client.model.response.Segment;
import ru.yandex.direct.metrika.client.model.response.TurnOnCallTrackingResponse;
import ru.yandex.direct.metrika.client.model.response.UpdateCounterGrantsResponse;
import ru.yandex.direct.metrika.client.model.response.UserCounters;
import ru.yandex.direct.metrika.client.model.response.UserCountersExtended;
import ru.yandex.direct.metrika.client.model.response.UserCountersExtendedResponse;
import ru.yandex.direct.metrika.client.model.response.UserCountersResponse;
import ru.yandex.direct.metrika.client.model.response.sources.SourcesResponse;
import ru.yandex.direct.metrika.client.model.response.statistics.StatisticsResponse;

/**
 * A high level client to metrika
 */
public interface MetrikaClient {
    // Данная ручка потенциально может вернуть до млн целей
    //используйте getGoals с фильтрами
    @Deprecated
    Map<Long, List<RetargetingCondition>> getGoalsByUids(Collection<Long> uids);

    GetGoalsResponse getGoals(GetGoalsRequest request);

    long estimateUsersByCondition(List<RetargetingGoalGroup> condition);

    Map<Long, Long> getUserNumberByRegions(Set<Long> counterIds, int limit, int days);

    Map<Long, Double> getProductImpressionsByCounterId(Set<Long> counterIds, int days);

    Map<Long, Long> getGoalsStatistics(List<Integer> counterIds, LocalDate dateFrom, LocalDate dateTo);

    Map<Integer, List<CounterGoal>> getMassCountersGoalsFromMetrika(Set<Integer> counterIds);

    // Данная ручка потенциально может вернуть до 300к счетчиков
    //используйте getUsersCountersNum2 с идентификаторами
    @Deprecated
    List<UserCounters> getUsersCountersNum(List<Long> uids);

    // аналог getUsersCountersNum, только с дополнительными фильтрами
    UserCountersResponse getUsersCountersNum2(List<Long> uids, Collection<Long> counterIds);

    // Данная ручка потенциально может вернуть до 300к счетчиков
    //используйте getUsersCountersNumExtended2 с идентификаторами
    @Deprecated
    List<UserCountersExtended> getUsersCountersNumExtended(List<Long> uids);

    // аналог getUsersCountersNumExtended, только с дополнительными фильтрами
    UserCountersExtendedResponse getUsersCountersNumExtended2(List<Long> uids, UserCountersExtendedFilter filter);

    UpdateCounterGrantsResponse updateCounterGrants(long counterId, Set<String> logins);

    List<Counter> getEditableCounters(@Nullable String tvmUserTicket);

    Counter getCounter(Long counterId);

    List<Segment> getSegments(int counterId, @Nullable String tvmUserTicket);

    Segment createSegment(int counterId, String name, String expression, @Nullable String tvmUserTicket);

    CreateCounterGoal createGoal(int counterId, CreateCounterGoal goalToCreate, @Nullable String tvmUserTicket);

    SourcesResponse getAvailableSources(MetrikaSourcesParams params);

    /**
     * Получает данные по сквозной аналитике из отчета "Источники, расходы и ROI"
     */
    StatisticsResponse getEndToEndStatistics(MetrikaByTimeStatisticsParams params);

    /**
     * Получает данные по источникам трафика из отчета "Источники, сводка"
     */
    StatisticsResponse getTrafficSourceStatistics(MetrikaByTimeStatisticsParams params);

    Map<Long, GoalConversionInfo> getGoalsConversionInfoByCounterIds(Collection<Integer> counterIds, int days);

    Map<Long, GoalConversionInfo> getGoalsConversionInfoByCounterIds(
            Collection<Integer> counterIds, LocalDate dateFrom, LocalDate dateTo);


    RequestGrantsResponse requestCountersGrants(RequestGrantsRequest request);

    GrantAccessRequestStatusesResponse getGrantAccessRequestStatuses(Long uid,
                                                                     GrantAccessRequestStatusesRequest request);

    GetExistentCountersResponse getExistentCounters(GetExistentCountersRequest request);

    TurnOnCallTrackingResponse turnOnCallTracking(Long counterId);

    default GetGoalsResponse getGoals(Collection<Long> uids, GoalType goalType) {
        var request = new GetGoalsRequest()
                .withUids(uids)
                .withGoalType(goalType);
        return getGoals(request);
    }
}
