package ru.yandex.direct.metrika.client;

public class MetrikaConfiguration {
    public static final String DEFAULT_INTAPI_URL = "http://internalapi-test.metrika.yandex.ru:8096";
    public static final String DEFAULT_AUDIENCE_URL = "http://ipv6.audience-intapid-test.metrika.yandex.ru:8099";
    public static final String DEFAULT_METRIKA_URL = "https://api-metrika-test.metrika.yandex.net";

    public static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 30000;

    private String intapiUrl;
    private String audienceUrl;
    private String metrikaUrl;
    private int connectTimeout;
    private int readTimeout;
    private boolean ignoreSslErrors = false;

    public MetrikaConfiguration() {
        this(getDefaultIntapiUrl(), getDefaultAudienceUrl(), getDefaultMetrikaUrl());
    }

    public MetrikaConfiguration(String intapiUrl, String audienceUrl, String metrikaUrl)
    {
        this.intapiUrl = intapiUrl;
        this.audienceUrl = audienceUrl;
        this.metrikaUrl = metrikaUrl;
        this.connectTimeout = getDefaultConnectTimeout();
        this.readTimeout = getDefaultReadTimeout();
    }

    /**
     * Returns the default intapi metrika url
     * <p>
     * Points to the testing server unless overridden in system properties
     */
    public static String getDefaultIntapiUrl() {
        return DEFAULT_INTAPI_URL;
    }

    /**
     * Returns the default intapi metrika url for audience-related calls
     * <p>
     * Points to the testing server unless overridden in system properties
     */
    public static String getDefaultAudienceUrl() {
        return DEFAULT_AUDIENCE_URL;
    }

    /**
     * Returns the default metrika url for the official api
     * <p>
     * Points to the testing server unless overridden in system properties
     */
    public static String getDefaultMetrikaUrl() {
        return DEFAULT_METRIKA_URL;
    }

    /**
     * Returns the default connect timeout, in milliseconds
     * <p>
     * The default is 5 seconds unless overridden in system properties
     */
    public static int getDefaultConnectTimeout() {
        return DEFAULT_CONNECT_TIMEOUT;
    }

    /**
     * Returns the default read timeout, in milliseconds
     * <p>
     * The default is 30 seconds unless overridden in system properties
     */
    public static int getDefaultReadTimeout() {
        return DEFAULT_READ_TIMEOUT;
    }

    /**
     * Returns intapi metrika url, used for most of internal calls
     */
    public String getIntapiUrl() {
        return intapiUrl;
    }

    /**
     * Sets intapi metrika url, used for most of internal calls
     */
    public void setIntapiUrl(String intapiUrl) {
        this.intapiUrl = intapiUrl;
    }

    /**
     * Returns inapi metrika url for audience-related calls (getGoalsByUids and estimateUsersByCondition)
     */
    public String getAudienceUrl() {
        return audienceUrl;
    }

    /**
     * Sets intapi metrika url for audience-related calls (getGoalsByUids and estimateUsersByCondition)
     */
    public void setAudienceUrl(String audienceUrl) {
        this.audienceUrl = audienceUrl;
    }

    /**
     * Returns metrika url for the official api
     */
    public String getMetrikaUrl() {
        return metrikaUrl;
    }

    /**
     * Sets metrika url for the official api
     */
    public void setMetrikaUrl(String metrikaUrl) {
        this.metrikaUrl = metrikaUrl;
    }

    /**
     * Returns the connect timeout, in milliseconds
     */
    public int getConnectTimeout() {
        return connectTimeout;
    }

    /**
     * Sets the connect timeout, in milliseconds
     */
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    /**
     * Returns the read timeout, in milliseconds
     */
    public int getReadTimeout() {
        return readTimeout;
    }

    /**
     * Sets the read timeout, in milliseconds
     */
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isIgnoreSslErrors() {
        return ignoreSslErrors;
    }

    public void setIgnoreSslErrors(boolean ignoreSslErrors) {
        this.ignoreSslErrors = ignoreSslErrors;
    }
}
