package ru.yandex.direct.metrika.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.metrika.client.model.request.GetGoalsRequest;
import ru.yandex.direct.metrika.client.model.request.GoalType;
import ru.yandex.direct.metrika.client.model.response.RetargetingCondition;

import static java.util.stream.Collectors.toSet;

public class MetrikaHelper {

    private final MetrikaClient metrikaClient;

    public MetrikaHelper(MetrikaClient metrikaClient) {
        this.metrikaClient = metrikaClient;
    }

    public MetrikaClient getMetrikaClient() {
        return metrikaClient;
    }

    public Set<Long> getGoalsIds(Collection<Long> uids, GoalType goalType) {
        return getGoalsIds(uids, goalType, null);
    }

    public Set<Long> getGoalsIds(Collection<Long> uids, GoalType goalType, Collection<Long> goalIds) {
        Map<Long, List<RetargetingCondition>> goalsByUids =
                metrikaClient.getGoals(new GetGoalsRequest()
                        .withUids(uids)
                        .withIds(goalIds)
                        .withGoalType(goalType))
                        .getUidToConditions();

        return goalsByUids.values().stream()
                .flatMap(Collection::stream)
                .map(RetargetingCondition::getId)
                .collect(toSet());
    }
}
