package ru.yandex.direct.metrika.client.asynchttp;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.direct.metrika.client.internal.EstimateUsersByConditionEnvelope;
import ru.yandex.direct.metrika.client.internal.MetrikaConditionBuilder;
import ru.yandex.direct.metrika.client.model.request.GoalType;
import ru.yandex.direct.metrika.client.model.response.GetGoalsResponse;
import ru.yandex.direct.metrika.client.model.response.RetargetingCondition;

public interface AudienceApi {

    @GET("/get_users_sketched")
    @Json
    Call<EstimateUsersByConditionEnvelope> estimateUsersByCondition(
            @Query("condition") MetrikaConditionBuilder lastTime);

    @POST("/direct/retargeting_conditions_check_access")
    @Json
    Call<Map<Long, List<Long>>> checkGoalsAccessByUids(@Query("uid") String uid, @Query("ids") String goalIds);

    @POST("/retargeting_conditions")
    @Json
    Call<Map<Long, List<RetargetingCondition>>> getGoalsByUids(@Query("uid") String uid);

    @POST("/retargeting_conditions_by_uids2")
    @Json
    Call<GetGoalsResponse> getGoals(@Query("uid") String uids, @Query("type") GoalType goalType,
                                    @Query("prefix") String prefix, @Query("ids") String ids,
                                    @Query("counter_as_goal") boolean isAddCounterAsGoals);
}
