package ru.yandex.direct.metrika.client.asynchttp;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.annotations.ResponseHandler;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.core.CallsPack;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.PUT;
import ru.yandex.direct.http.smart.http.PartibleQuery;
import ru.yandex.direct.http.smart.http.Path;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.direct.metrika.client.UpdateCounterGrantsMetrikaRequest;
import ru.yandex.direct.metrika.client.internal.CountersGoalsJsonResponseConverter;
import ru.yandex.direct.metrika.client.model.request.GetExistentCountersRequest;
import ru.yandex.direct.metrika.client.model.request.GrantAccessRequestStatusesRequest;
import ru.yandex.direct.metrika.client.model.request.RequestGrantsRequest;
import ru.yandex.direct.metrika.client.model.response.GetCountersGoalsResponse;
import ru.yandex.direct.metrika.client.model.response.GetExistentCountersResponse;
import ru.yandex.direct.metrika.client.model.response.GoalConversionsCountResponse;
import ru.yandex.direct.metrika.client.model.response.GrantAccessRequestStatusesResponse;
import ru.yandex.direct.metrika.client.model.response.RequestGrantsResponse;
import ru.yandex.direct.metrika.client.model.response.TurnOnCallTrackingResponse;
import ru.yandex.direct.metrika.client.model.response.UserCounters;
import ru.yandex.direct.metrika.client.model.response.UserCountersExtended;
import ru.yandex.direct.metrika.client.model.response.UserCountersExtendedResponse;
import ru.yandex.direct.metrika.client.model.response.UserCountersResponse;

public interface IntApi {

    @POST("/direct/user_counters_num")
    @Json
    Call<List<UserCounters>> getUsersCountersNum(@Query("uids") String uids);

    @POST("/direct/user_counters_num2")
    @Json
    Call<UserCountersResponse> getUsersCountersNum2(@Query("uids") String uids, @Query("counterIds") String counterIds);

    @POST("/direct/user_counters_num_extended")
    @Json
    Call<List<UserCountersExtended>> getUsersCountersNumExtended(@Query("uids") String uids);

    @POST("/direct/user_counters_num_extended2")
    @Json
    Call<UserCountersExtendedResponse> getUsersCountersNumExtended2(@Query("uids") String uids, @Query("counterIds") String counterIds,
                                                                    @Query("prefix") String prefix, @Query("limit") Integer limit);

    @GET("/direct/counter_goals")
    @ResponseHandler(parserClass = CountersGoalsJsonResponseConverter.class)
    CallsPack<GetCountersGoalsResponse> getCountersGoals(@PartibleQuery("counters") Set<Integer> counterIds);

    @GET("/direct/get_goal_counts")
    @Json
    CallsPack<GoalConversionsCountResponse> getGoalCounts(
            @PartibleQuery("counterIds") List<Integer> counterIds,
            @Query("startDate") String dateFrom, @Query("endDate") String dateTo);

    @PUT("/yandexservices/edit_counter/{counter_id}")
    @Json
    Call<Object> updateCounterGrants(
            @Path("counter_id") long counterId,
            @Query("quota_ignore") String quotaIgnore,
            @Body @Json UpdateCounterGrantsMetrikaRequest jsonBody);

    @POST("/internal/grant_requests")
    @Json
    Call<RequestGrantsResponse> requestGrants(
            @Body @Json RequestGrantsRequest requestGrantsRequest);

    @POST("/internal/user/{uid}/grant_access_requests_status")
    @Json
    Call<GrantAccessRequestStatusesResponse> getGrantAccessRequestStatuses(
            @Path("uid") long uid,
            @Body @Json GrantAccessRequestStatusesRequest request);

    @POST("/internal/existent_counters")
    @Json
    Call<GetExistentCountersResponse> getExistentCounters(
            @Body @Json GetExistentCountersRequest request);

    @POST("/direct/turn_on_call_tracking")
    @Json
    Call<TurnOnCallTrackingResponse> turnOnCallTracking(@Query("counterId") long counterId);
}
