package ru.yandex.direct.metrika.client.asynchttp;

import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.core.CallsPack;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.HeaderMap;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.PartibleQuery;
import ru.yandex.direct.http.smart.http.Path;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.direct.metrika.client.internal.CreateGoalRequestEnvelope;
import ru.yandex.direct.metrika.client.internal.CreateGoalResponseEnvelope;
import ru.yandex.direct.metrika.client.internal.CreateSegmentRequestEnvelope;
import ru.yandex.direct.metrika.client.internal.CreateSegmentResponseEnvelope;
import ru.yandex.direct.metrika.client.internal.GetCounterGoalsEnvelope;
import ru.yandex.direct.metrika.client.internal.GetCounterResponseEnvelope;
import ru.yandex.direct.metrika.client.internal.GetCountersResponseEnvelope;
import ru.yandex.direct.metrika.client.internal.GetSegmentsEnvelope;
import ru.yandex.direct.metrika.client.internal.GetStatByDateResult;
import ru.yandex.direct.metrika.client.internal.GetStatResult;

public interface MetrikaApi {

    @GET("/stat/v1/data?metrics=ym:s:productImpressions&dimensions=ym:s:counterID")
    @Json
    CallsPack<GetStatResult> getProductImpressions(
            @PartibleQuery("ids") Set<Long> counterIds,
            @Query("date1") String date1, @Query("date2") String date2);

    @GET("/stat/v1/data?metrics=ym:s:users&sort=-ym:s:users")
    @Json
    CallsPack<GetStatResult> getUserCountByDimensions(
            @Query("ids") Set<Long> counterIds,
            @PartibleQuery("dimensions") Set<String> dimensions,
            @Query("limit") Integer limit,
            @Query("date1") String date1, @Query("date2") String date2);

    @GET("stat/v1/data?metrics=ym:s:visits&dimensions=ym:s:goal")
    @Json
    CallsPack<GetStatResult> getGoalsStatistics(
            @PartibleQuery("ids") List<Integer> counterIds,
            @Query("limit") Integer limit,
            @Query("date1") String dateFrom, @Query("date2") String dateTo);

    /**
     * Получение значений метрик по выбранным срезам за период
     */
    @GET("stat/v1/data/bytime?accuracy=1")
    @Json
    Call<GetStatByDateResult> getByTimeStat(
            @Query("id") Long id,
            @Query("group") String dateGroup,
            @Query("attribution") String attribution,
            @Query("currency") String currencyCode,
            @Query("dimensions") String dimensions,
            @Query("metrics") String metrics,
            @Query("goal_id") Long goalId,
            @Query("date1") String dateFrom,
            @Query("date2") String dateTo,
            @Query("row_ids") String rowIds,
            @Query("direct_client_logins") String directClientLogins
    );

    /**
     * Получение суммарных значений метрик по выбранным срезам за период
     */
    @GET("stat/v1/data")
    @Json
    Call<GetStatResult> getStatData(
            @Query("id") Long id,
            @Query("attribution") String attribution,
            @Query("dimensions") String dimensions,
            @Query("metrics") String metrics,
            @Query("filters") String filters,
            @Query("limit") Long limit,
            @Query("date1") String dateFrom,
            @Query("date2") String dateTo
    );

    @GET("/management/v1/counter/{counter_id}/goals")
    @Json
    Call<GetCounterGoalsEnvelope> getCounterGoals(@Path("counter_id") int counterId);

    @GET("/management/v1/counters")
    @Json
    Call<GetCountersResponseEnvelope> getCounters(
            @Query("permission") String permission,
            @HeaderMap Map<String, String> headers);

    @GET("/management/v1/counter/{counter_id}")
    @Json
    Call<GetCounterResponseEnvelope> getCounter(@Path("counter_id") long counterId);

    @GET("/management/v1/counter/{counter_id}/segments")
    @Json
    Call<GetSegmentsEnvelope> getSegments(@Path("counter_id") int counterId, @HeaderMap Map<String, String> headers);

    @POST("/management/v1/counter/{counter_id}/segments")
    @Json
    Call<CreateSegmentResponseEnvelope> createSegment(
            @Path("counter_id") int counterId,
            @HeaderMap Map<String, String> headers,
            @Body @Json CreateSegmentRequestEnvelope requestBody);

    @POST("/management/v1/counter/{counter_id}/goals")
    @Json
    Call<CreateGoalResponseEnvelope> createGoals(
            @Path("counter_id") int counterId,
            @HeaderMap Map<String, String> headers,
            @Body @Json CreateGoalRequestEnvelope requestBody);
}
