package ru.yandex.direct.metrika.client.internal

import com.fasterxml.jackson.annotation.JsonCreator

/**
 * Типы атрибуции, используемые в API Метрики
 *
 * [Документация API Метрики](https://yandex.ru/dev/metrika/doc/api2/api_v1/param.html)
 */
enum class Attribution {
    FIRST,
    LAST,
    LASTSIGN,
    LAST_YANDEX_DIRECT_CLICK,
    CROSS_DEVICE_FIRST,
    CROSS_DEVICE_LAST,
    CROSS_DEVICE_LAST_SIGNIFICANT,
    CROSS_DEVICE_LAST_YANDEX_DIRECT_CLICK,

    UNKNOWN
    ;

    companion object {
        val enumByString = values().map { it.name.lowercase() to it }.toMap()

        /**
         * Если нужный enum не нашёлся, вернётся [UNKNOWN]
         */
        @JvmStatic
        @JsonCreator
        fun fromString(str: String?) = enumByString[str?.lowercase()] ?: UNKNOWN
    }
}
