package ru.yandex.direct.metrika.client.internal;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateSegmentRequestEnvelope {

    private SegmentData segment;

    public SegmentData getSegment() {
        return segment;
    }

    public CreateSegmentRequestEnvelope withSegment(SegmentData segment) {
        this.segment = segment;
        return this;
    }

    public void setSegment(SegmentData segment) {
        this.segment = segment;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class SegmentData {
        private String name;
        private String expression;

        public String getName() {
            return name;
        }

        public SegmentData withName(String name) {
            this.name = name;
            return this;
        }

        public String getExpression() {
            return expression;
        }

        public SegmentData withExpression(String expression) {
            this.expression = expression;
            return this;
        }
    }
}
