package ru.yandex.direct.metrika.client.internal;

import java.util.Objects;

public class Dimension {
    private String id;
    private String name;

    // no-arg конструктор для десериализации
    public Dimension() {
    }

    public Dimension(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Dimension dimension = (Dimension) o;
        return Objects.equals(id, dimension.id) && Objects.equals(name, dimension.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name);
    }

    @Override
    public String toString() {
        return "Dimension{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
