package ru.yandex.direct.metrika.client.internal

import ru.yandex.direct.currency.CurrencyCode
import java.time.LocalDate

/**
 * Параметры запросов статистики из Метрики.
 * Используется в
 * [ru.yandex.direct.metrika.client.MetrikaClient.getEndToEndStatistics] и
 * [ru.yandex.direct.metrika.client.MetrikaClient.getTrafficSourceStatistics]
 * @property chiefLogin Логин главного представителя клиента.
 * Используется в [ru.yandex.direct.metrika.client.MetrikaClient.getEndToEndStatistics]
 * для получения статистики по директовым кампаниям клиента.
 * Если `null` или логин не главного представителя,
 * то статистика по Директу не собирается.
 * @property attribution Модель атрибуции.
 * Если `null`, будет использовано дефолтное значение Метрики - [Attribution.LASTSIGN]
 * @property currencyCode Валюта для отдачи данных о расходах.
 * Если `null`, будет использована дефолтная валюта счётчика
 * @property goalId ID цели.
 * Если `null`, то статистика по целевым метрикам будет браться по всем целям.
 * @property rowIds Перечисление списков ключей группировок.
 * Если задан, определяет выбор группировок для получения статистики.
 */
data class MetrikaByTimeStatisticsParams(
    val chiefLogin: String?,
    val counterId: Long,
    val attribution: Attribution?,
    val currencyCode: CurrencyCode?,
    val goalId: Long?,
    val skipGoalData: Boolean = false,
    val withRevenue: Boolean = false,
    val withConversionRate: Boolean = false,
    val dateFrom: LocalDate,
    val dateTo: LocalDate,
    val rowIds: List<List<String>>?
)
