package ru.yandex.direct.metrika.client.internal;

import java.util.List;

import ru.yandex.direct.metrika.client.model.request.RetargetingGoal;
import ru.yandex.direct.metrika.client.model.request.RetargetingGoalGroup;

public class MetrikaConditionBuilder {
    private StringBuilder sb = new StringBuilder();

    public void appendGoal(RetargetingGoal goal) {
        sb.append("id==");
        sb.append(goal.getId());
        sb.append(" interval ");
        sb.append(goal.getDays());
        sb.append(" days");
    }

    public void appendGoalGroup(RetargetingGoalGroup goalGroup) {
        boolean first = true;
        RetargetingGoalGroup.Type type = goalGroup.getType();
        for (RetargetingGoal goal : goalGroup.getGoals()) {
            if (first) {
                first = false;
            } else {
                sb.append(type.getJoiner());
            }
            sb.append(type.getGoalPrefix());
            appendGoal(goal);
        }
    }

    public void appendCondition(List<RetargetingGoalGroup> condition) {
        boolean first = true;
        boolean addBrackets = condition.size() > 1;
        for (RetargetingGoalGroup goalGroup : condition) {
            if (first) {
                first = false;
            } else {
                sb.append(" and ");
            }
            if (addBrackets) {
                sb.append('(');
            }
            appendGoalGroup(goalGroup);
            if (addBrackets) {
                sb.append(')');
            }
        }
    }

    @Override
    public String toString() {
        return sb.toString();
    }
}
