package ru.yandex.direct.metrika.client.internal

import java.time.LocalDate

/**
 * Параметры запроса источников из Метрики.
 * Используется в
 * [ru.yandex.direct.metrika.client.MetrikaClient.getAvailableSources].
 * Параметры [categories] и [channels] задают фильтр на запрос источников -
 * источник должен либо быть среди [channels], либо входить в категорию из [categories].
 * @property attribution Модель атрибуции.
 * Если `null`, будет использовано дефолтное значение Метрики - [Attribution.LASTSIGN]
 * @property categories Категории источников.
 * @property channels Конкретные источники.
 */
data class MetrikaSourcesParams(
    val counterId: Long,
    val attribution: Attribution?,
    val categories: List<String>?,
    val channels: List<String>?,
    val dateFrom: LocalDate,
    val dateTo: LocalDate,
    val limit: Long?
)
