package ru.yandex.direct.metrika.client.internal;

import java.math.BigDecimal;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class StatData {
    private List<Dimension> dimensions;
    private List<BigDecimal> metrics;

    public List<Dimension> getDimensions() {
        return dimensions;
    }

    public void setDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public List<BigDecimal> getMetrics() {
        return metrics;
    }

    public void setMetrics(List<BigDecimal> metrics) {
        this.metrics = metrics;
    }

    public Long getFirstDimensionIdAsLong() {
        return this.getDimensions()
                .stream()
                .findAny()
                .map(Dimension::getId)
                .map(Long::valueOf)
                .orElseThrow(IllegalStateException::new);
    }

    public Long getMetricAsLong() {
        return getMetric().longValue();
    }

    public Double getMetricAsDouble() {
        return getMetric().doubleValue();
    }

    private BigDecimal getMetric() {
        return this.getMetrics().stream()
                .findAny()
                .orElseThrow(IllegalStateException::new);
    }
}
