package ru.yandex.direct.metrika.client.model.request;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class CounterIdsBaseRequest<RequestType> {

    @JsonProperty("counter_id_list")
    private List<Long> counterIds;

    public RequestType withCounterIds(List<Long> counterIds) {
        this.counterIds = counterIds;
        return (RequestType) this;
    }

    public List<Long> getCounterIds() {
        return counterIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CounterIdsBaseRequest<?> that = (CounterIdsBaseRequest<?>) o;
        return Objects.equals(counterIds, that.counterIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(counterIds);
    }
}
