package ru.yandex.direct.metrika.client.model.request;

import java.util.Collection;
import java.util.Objects;

import javax.annotation.Nullable;

public class GetGoalsRequest {
    private Collection<Long> uids;
    @Nullable
    private GoalType goalType;
    @Nullable
    private String prefix;
    @Nullable
    private Collection<Long> ids;

    /*
     * https://st.yandex-team.ru/AUDIENCE-1318
     * According to some legacy logic Counter itself is a Goal
     */
    private Boolean countCountersAsGoals = true;

    public Collection<Long> getUids() {
        return uids;
    }

    public GetGoalsRequest withUids(Collection<Long> uids) {
        this.uids = uids;
        return this;
    }

    public @Nullable GoalType getGoalType() {
        return goalType;
    }

    public GetGoalsRequest withGoalType(GoalType goalType) {
        this.goalType = goalType;
        return this;
    }

    public @Nullable String getPrefix() {
        return prefix;
    }

    public GetGoalsRequest withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public @Nullable Collection<Long> getIds() {
        return ids;
    }

    public GetGoalsRequest withIds(Collection<Long> ids) {
        this.ids = ids;
        return this;
    }

    public Boolean getCountCountersAsGoals() {
        return countCountersAsGoals;
    }

    public GetGoalsRequest withCountCountersAsGoals(Boolean value) {
        this.countCountersAsGoals = value;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetGoalsRequest that = (GetGoalsRequest) o;
        return Objects.equals(uids, that.uids) &&
                goalType == that.goalType &&
                Objects.equals(prefix, that.prefix) &&
                Objects.equals(ids, that.ids) &&
                countCountersAsGoals == that.countCountersAsGoals;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uids, goalType, prefix, ids, countCountersAsGoals);
    }
}
