package ru.yandex.direct.metrika.client.model.request;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class RequestGrantsRequest {

    @JsonProperty("requests")
    private List<RequestGrantsRequestItem> requestItems;

    public void setRequestItems(List<RequestGrantsRequestItem> requestItems) {
        this.requestItems = requestItems;
    }

    public List<RequestGrantsRequestItem> getRequestItems() {
        return requestItems;
    }

    public RequestGrantsRequest withRequestItems(List<RequestGrantsRequestItem> requestItems) {
        this.requestItems = requestItems;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RequestGrantsRequest that = (RequestGrantsRequest) o;
        return Objects.equals(requestItems, that.requestItems);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestItems);
    }
}
