package ru.yandex.direct.metrika.client.model.request;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class RequestGrantsRequestItem {

    public static final String DIRECT_SERVICE_NAME = "direct";

    @JsonProperty("object_type")
    private RequestGrantsObjectType objectType;

    @JsonProperty("object_id")
    private String objectId;

    @JsonProperty("permission")
    private RequestGrantsPermissionType permission;

    @JsonProperty("service_name")
    private String serviceName;

    @JsonProperty("requestor_login")
    private String requesterLogin;

    @JsonProperty("owner_login")
    private String ownerLogin;

    public RequestGrantsRequestItem() {
        this.serviceName = DIRECT_SERVICE_NAME;
    }

    public RequestGrantsRequestItem withObjectType(RequestGrantsObjectType objectType) {
        this.objectType = objectType;
        return this;
    }

    public RequestGrantsRequestItem withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    public RequestGrantsRequestItem withPermission(RequestGrantsPermissionType permission) {
        this.permission = permission;
        return this;
    }

    public RequestGrantsRequestItem withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public RequestGrantsRequestItem withRequesterLogin(String requesterLogin) {
        this.requesterLogin = requesterLogin;
        return this;
    }

    public RequestGrantsRequestItem withOwnerLogin(String ownerLogin) {
        this.ownerLogin = ownerLogin;
        return this;
    }

    public RequestGrantsObjectType getObjectType() {
        return objectType;
    }

    public void setObjectType(RequestGrantsObjectType objectType) {
        this.objectType = objectType;
    }

    public String getObjectId() {
        return objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public RequestGrantsPermissionType getPermission() {
        return permission;
    }

    public void setPermission(RequestGrantsPermissionType permission) {
        this.permission = permission;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getRequesterLogin() {
        return requesterLogin;
    }

    public void setRequesterLogin(String requesterLogin) {
        this.requesterLogin = requesterLogin;
    }

    public String getOwnerLogin() {
        return ownerLogin;
    }

    public void setOwnerLogin(String ownerLogin) {
        this.ownerLogin = ownerLogin;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RequestGrantsRequestItem that = (RequestGrantsRequestItem) o;
        return objectType == that.objectType &&
                Objects.equals(objectId, that.objectId) &&
                permission == that.permission &&
                Objects.equals(serviceName, that.serviceName) &&
                Objects.equals(requesterLogin, that.requesterLogin) &&
                Objects.equals(ownerLogin, that.ownerLogin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(objectType, objectId, permission, serviceName, requesterLogin, ownerLogin);
    }
}
